/*
 * QrfeComplexNumber.h
 *
 *  Created on: 26.03.2012
 *      Author: stefan.detter
 */

#ifndef QRFECOMPLEXNUMBER_H_
#define QRFECOMPLEXNUMBER_H_

#include <QDataStream>
#include <QString>

class QrfeComplexNumber
{
public:
    QrfeComplexNumber();
    QrfeComplexNumber(double re);
    QrfeComplexNumber(double re, double im);
    QrfeComplexNumber(const QrfeComplexNumber& other);

    double 	realPart();
    double 	imaginaryPart();
    void 	setRealPart(double re);
    void 	setImaginaryPart(double im);

    double 	absoluteValue();
    double 	phase();

    QString toString ( int precision = -1 );

    QrfeComplexNumber& operator= ( const QrfeComplexNumber& c );

    friend QrfeComplexNumber operator+ ( const QrfeComplexNumber& c1, const QrfeComplexNumber& c2);
    friend QrfeComplexNumber operator- ( const QrfeComplexNumber& c1, const QrfeComplexNumber& c2);
    friend QrfeComplexNumber operator* ( const QrfeComplexNumber& c1, const QrfeComplexNumber& c2);
    friend QrfeComplexNumber operator/ ( const QrfeComplexNumber& c1, const QrfeComplexNumber& c2);

    friend QDataStream& operator<<(QDataStream& stream, const QrfeComplexNumber & complex);
    friend QDataStream& operator>>(QDataStream& stream, QrfeComplexNumber & complex);

private:
    double m_realPart;
    double m_imaginaryPart;
    bool 	m_infinity;
};




#endif /* QRFECOMPLEXNUMBER_H_ */
